/* Copyright (c) 2008 Nordic Semiconductor. All Rights Reserved.
 *
 * The information contained herein is property of Nordic Semiconductor ASA.
 * Terms and conditions of usage are described in detail in NORDIC
 * SEMICONDUCTOR STANDARD SOFTWARE LICENSE AGREEMENT. 
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRENTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 *
 * $LastChangedRevision: 4640 $
 */ 

/* This program enables the user to check the connection between two radios on nRF24LE1.

Transmitter:
Will send a turn off signal (reset pin is held low on SM72442) once button 0 is pressed
Will send a turn on signal (reset pin is released) once button 0 is depressed
Will send a panel mode signal (panel mode pin is held low) once button 1 is pressed
Will send a release panel mode signal once button 1 is depressed
*/

#include <Nordic\reg24le1.h>
#include "hal_nrf_reg.h"
#include "hal_nrf.h"
#include "radio.h"
#include "application.h"

uint8_t xdata packet[RADIO_MAX_PL];

void send_packet(uint8_t command)
{
	uint8_t data_length;
	
	packet[0] = 0x00;
	packet[1] = data_length = 1;
	packet[DATA_POS] = command;
	

    radio_send_packet_noack(packet, data_length+DATA_POS); //sending packet with no acknowledgement	from receiver
}

uint8_t read_packet(void)
{
	uint8_t command, type, data_length, pck_length;
	pck_length = radio_read_data (packet);

	type = packet[0];
	data_length = packet[1];
	command = packet[DATA_POS];

	return command;
}

void radio_irq(void) interrupt RF_READY_INT_VECT  
{
  radio_interrupt();  
}

void main (void)
{
	P0 = 0;
	P0DIR = 0x03;

	RFCKEN = 1;
	RF = 1;
	EA = 1;

	radio_init(1);	 //configure radio as a transmitter

	while (true)
	{	
		while (radio_busy());		
				while (B0 && B1) //release shutdown and panel mode operation when B0 and B1 is released 
				{
							send_packet(CMD2);
							delay_10ms();					
				}
				while (!B0)	// sending shutdown signal when B0 is pressed
				{
							send_packet (CMD1);
							delay_10ms();
							
				}
 		
				while (B0 && !B1) //sending panel mode signal when B0 is released and B1 is pressed 
				{ 			
							send_packet (CMD3);
							delay_10ms();
							
				}
	}
}			  




	
